import '../auth/sign_up_model/registration_response_model.dart';

class AddMoneyMethodResponseModel {
  AddMoneyMethodResponseModel({
    String? remark,
    Message? message,
    Data? data,
  }) {
    _remark = remark;
    _message = message;
    _data = data;
  }

  AddMoneyMethodResponseModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _message = json['message'] != null ? Message.fromJson(json['message']) : null;
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  Message? _message;
  Data? _data;

  String? get remark => _remark;
  Message? get message => _message;
  Data? get data => _data;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['remark'] = _remark;
    if (_message != null) {
      map['message'] = _message?.toJson();
    }
    if (_data != null) {
      map['data'] = _data?.toJson();
    }
    return map;
  }
}

class Data {
  Data({
    List<Gateways>? methods,
  }) {
    _methods = methods;
  }

  Data.fromJson(dynamic json) {
    if (json['methods'] != null) {
      _methods = [];
      json['methods'].forEach((v) {
        _methods?.add(Gateways.fromJson(v));
      });
    }
  }
  List<Gateways>? _methods;

  List<Gateways>? get methods => _methods;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_methods != null) {
      map['methods'] = _methods?.map((v) => v.toJson()).toList();
    }
    return map;
  }
}



class Gateways {
  Gateways({
    int? id,
    String? name,
    String? currency,
    String? symbol,
    String? methodCode,
    String? gatewayAlias,
    String? minAmount,
    String? maxAmount,
    String? percentCharge,
    String? fixedCharge,
    String? rate,
    dynamic image,
    dynamic gatewayParameter,
    String? createdAt,
    String? updatedAt,
    String? depositMinLimit,
    String? depositMaxLimit,
  }) {
    _id = id;
    _name = name;
    _currency = currency;
    _symbol = symbol;
    _methodCode = methodCode;
    _gatewayAlias = gatewayAlias;
    _minAmount = minAmount;
    _maxAmount = maxAmount;
    _percentCharge = percentCharge;
    _fixedCharge = fixedCharge;
    _rate = rate;
    _image = image;
    _gatewayParameter = gatewayParameter;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _depositMinLimit = depositMinLimit;
    _depositMaxLimit = depositMaxLimit;
  }

  Gateways.fromJson(dynamic json) {
    _id = json['id'];
    _name = json['name'];
    _currency = json['currency'];
    _symbol = json['symbol'];
    _methodCode = json['method_code'].toString();
    _gatewayAlias = json['gateway_alias'].toString();
    _minAmount = json['min_amount'].toString();
    _maxAmount = json['max_amount'].toString();
    _percentCharge = json['percent_charge'].toString();
    _fixedCharge = json['fixed_charge'].toString();
    _rate = json['rate'].toString();
    _image = json['image'] != null ? json['image'].toString() : "";
    _gatewayParameter = json['gateway_parameter'];
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    _depositMinLimit = json['deposit_min_limit'].toString();
    _depositMaxLimit = json['deposit_max_limit'].toString();
  }
  int? _id;
  String? _name;
  String? _currency;
  String? _symbol;
  String? _methodCode;
  String? _gatewayAlias;
  String? _minAmount;
  String? _maxAmount;
  String? _percentCharge;
  String? _fixedCharge;
  String? _rate;
  dynamic _image;
  dynamic _gatewayParameter;
  String? _createdAt;
  String? _updatedAt;
  String? _depositMinLimit;
  String? _depositMaxLimit;

  int? get id => _id;
  String? get name => _name;
  String? get currency => _currency;
  String? get symbol => _symbol;
  String? get methodCode => _methodCode;
  String? get gatewayAlias => _gatewayAlias;
  String? get minAmount => _minAmount;
  String? get maxAmount => _maxAmount;
  String? get percentCharge => _percentCharge;
  String? get fixedCharge => _fixedCharge;
  String? get rate => _rate;
  dynamic get image => _image;
  dynamic get gatewayParameter => _gatewayParameter;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  String? get depositMinLimit => _depositMinLimit;
  String? get depositMaxLimit => _depositMaxLimit;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['name'] = _name;
    map['currency'] = _currency;
    map['symbol'] = _symbol;
    map['method_code'] = _methodCode;
    map['gateway_alias'] = _gatewayAlias;
    map['min_amount'] = _minAmount;
    map['max_amount'] = _maxAmount;
    map['percent_charge'] = _percentCharge;
    map['fixed_charge'] = _fixedCharge;
    map['rate'] = _rate;
    map['image'] = _image;
    map['gateway_parameter'] = _gatewayParameter;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    map['deposit_min_limit'] = _depositMinLimit;
    map['deposit_max_limit'] = _depositMaxLimit;
    return map;
  }
}
